<?php
/*--------------------------------------------------------------------
 Repository.php 2020-2-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\CombisIdDtoCollection;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\Readers\ReaderInterface;

/**
 * Class Repository
 * @package Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository
 */
class Repository implements RepositoryInterface
{
    
    /**
     * @var ReaderInterface
     */
    protected $reader;
    
    
    /**
     * Repository constructor.
     *
     * @param ReaderInterface $reader
     */
    public function __construct(ReaderInterface $reader)
    {
        $this->reader = $reader;
    }
    
    
    /**
     * @inheritDoc
     */
    public function availableCombisIds(ProductId $productId): CombisIdDtoCollection
    {
        return $this->reader->availableCombisIds($productId);
    }
}